/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CMessage.h,v 1.2 1999/09/17 04:20:47 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CMessage_h	// [
#define Included_CMessage_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

// Class CMessage

class CMessage
{
public:
	CMessage(UINT message = 0, WPARAM wParam = 0, LPARAM lParam = 0, 
		HWND hwnd = NULL, DWORD time = 0, POINT *pPoint = NULL);

	CMessage(MSG message);

	operator MSG&()				{return mMessage;}
	operator const MSG&() const {return mMessage;}

	operator MSG *() {return &mMessage;}
	operator const MSG *() const {return &mMessage;}

	const HWND&		Handle() const {return mMessage.hwnd;}
	HWND&			Handle() {return mMessage.hwnd;}

	const UINT&		Message() const {return mMessage.message;}
	UINT&			Message() {return mMessage.message;}

	const WPARAM&	WParam() const {return mMessage.wParam;}
	WPARAM&			WParam() {return mMessage.wParam;}

	const LPARAM&	LParam() const {return mMessage.lParam;}
	LPARAM&			LParam() {return mMessage.lParam;}

	const DWORD&	Time() const {return mMessage.time;}
	DWORD&			Time() {return mMessage.time;}

	const POINT&	Point() const {return mMessage.pt;}
	POINT&			Point() {return mMessage.pt;}

	PGPInt32	Get(HWND hwnd = NULL, PGPUInt32 filterMin = 0, 
		PGPUInt32 filterMax = 0);
	PGPInt32	Peek(PGPUInt32 rmFlags = PM_NOREMOVE, HWND hwnd = NULL, 
		PGPUInt32 filterMin = 0, PGPUInt32 filterMax = 0);

	PGPBoolean	Translate();
	LONG		Dispatch();

	void Reset();

private:
	MSG	mMessage;

	Init(UINT message, WPARAM wParam, LPARAM lParam, HWND hwnd, DWORD time, 
		POINT *pPoint = NULL);
};


// Class CMessage member functions

inline 
CMessage::CMessage(
	UINT	message, 
	WPARAM	wParam, 
	LPARAM	lParam, 
	HWND	hwnd, 
	DWORD	time, 
	POINT	*pPoint)
{
	Init(message, wParam, lParam, hwnd, time, pPoint);
}

inline 
CMessage::CMessage(MSG message)
{
	mMessage = message;
}

inline 
PGPInt32 
CMessage::Get(HWND hwnd, PGPUInt32 filterMin, PGPUInt32 filterMax)
{
	return GetMessage(&mMessage, hwnd, filterMin, filterMax);
}

inline 
PGPInt32 
CMessage::Peek(
	PGPUInt32	rmFlags, 
	HWND		hwnd, 
	PGPUInt32	filterMin, 
	PGPUInt32	filterMax)
{
	return PeekMessage(&mMessage, hwnd, filterMin, filterMax, rmFlags);
}

inline 
PGPBoolean 
CMessage::Translate()
{
	return TranslateMessage(&mMessage);
}

inline 
LONG 
CMessage::Dispatch()
{
	return DispatchMessage(&mMessage);
}

inline 
CMessage::Init(
	UINT	message, 
	WPARAM	wParam, 
	LPARAM	lParam, 
	HWND	hwnd, 
	DWORD	time, 
	POINT	*pPoint)
{
	mMessage.hwnd		= hwnd;
	mMessage.message	= message;
	mMessage.wParam		= wParam;
	mMessage.lParam		= lParam;
	mMessage.time		= time;

	if (IsntNull(pPoint))
		mMessage.pt = *pPoint;
}

_PGP_END

#endif	// ] Included_CMessage_h
